<%@ page language="java" contentType="text/html;charset=UTF-8" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/WEB-INF/displaytag-12.tld" prefix="display" %>
<%@ taglib uri="http://beehive.apache.org/netui/tags-html-1.0" prefix="netui" %>

<c:set var="pageHelp" value="${pageFlow.SEISummaryHelpURI}" />
<c:set var="printerFriendlySEIPageAction" value="viewSEIPrinterFriendlyIndex" />
<%@ include file="seiPageHeader.jspf" %>
<%@ include file="seiIndexDescription.jspf" %>

<netui:anchor href="${pageFlow.SEIAllergyUrl}">
	   		Add/Edit Self Entered Allergy
</netui:anchor>



<br>
----------------------------------------------------------------------------------------------------------------
<br>

<netui:form id="allergySource" action="allergySource" tagId="allergySource">
 <div id="filterFields">
  <h4>Filter Result</h4>
  <p>Select a source below and click the "Go" button to view the results.</p>
  <table width="100%" border="0">
   <tr>
    <td width="31%" height="137">
	 <div class="filterField" id="allergySource">
	 <fieldset>
      <legend>Source</legend>
        <table width="100%" border="0">
            <tr>   
        	    <netui:radioButtonGroup dataSource="actionForm.allergySource" defaultValue="NV">
                <td>
        			<netui:radioButtonOption tagId="showSourceVA" value="V">&nbsp;<label for="showSourceVA">VA </label></netui:radioButtonOption>
				</td>
			</tr>
			<tr>
        		<td>
			    	<netui:radioButtonOption tagId="showSourceNonVA" value="NV">&nbsp;<label for="showSourceNonVA">Self-entered</label></netui:radioButtonOption>
			    </td>
			</tr>
			<tr>
				<td>
			    	<netui:radioButtonOption tagId="showSourceBoth" value="B">&nbsp;<label for="showSourceBoth">Both</label></netui:radioButtonOption>
			    </td>
			</tr>
          </table>
              </netui:radioButtonGroup>
	 </fieldset></div></td>
     <td width="69%" valign="bottom">
		<netui:button alt="Go" title="Go" value="Go" action="allergySource"/>
	 </td>
   </tr>
   </table>
</netui:form>


<display:table sort="list" 
			   name="${pageFlow.SEIAllergyTableDecorators}"
               pagesize="10"
			   id="${pageFlow.tableUID}" 
	           uid="${pageFlow.tableUID}"
 	           defaultsort="${pageFlow.SEIDefaultSortProperty}" 
	           defaultorder="${pageFlow.defaultSortOrder.name}"	                                
               summary="List of Allergy SEI"
			   requestURI="handleSEIPagingAndSorting.do">
	    <display:setProperty name="custom.sort.class" 
            value="${pageFlow.SEISortClassName}" />               
    	<display:setProperty name="basic.msg.empty_list_row"
	    	value="0 items found" />
    <display:column property="SEIDate" sortProperty="SEICollectedOnDate" title="Date" sortable="true" />	    	             
    <display:column property="SEIAllergyRecord" title="Allergy" sortable="true"
                    href="viewSEIDetails.do" paramId="SEIId" paramProperty="SEIId"  />
    <display:column property="SEISeverity" title="Severity" sortable="true" />
    <display:column property="SEISource" title="Source" sortable="true" />
</display:table>

<hr/>

<br/>
<%@ include file="goldStandardText.jspf"%>
<br/>
<%@ include file="seiDisclaimer.jspf" %>